rm(list=ls())
library(copula)
library(matlib)
lam1=1 
lam2=1  
mu0=c(1,1)


tau=0.3   # Kendall's Tau
theta<-iTau(gumbelCopula(dim=2),tau=tau)
cop=mvdc(gumbelCopula(param=theta,dim=2)
         ,margins = c("exp","exp"),
         list(list(1/lam1),list(1/lam2)))

#estimate variance-covarianc matrix
dat=rMvdc(1000000,cop)
sigma=matrix(NA,ncol=2,nrow=2)
sigma[1,1]=var(dat[,1])
sigma[2,2]=var(dat[,2])
sigma[1,2]=cov(dat[,1],dat[,2])
sigma[2,1]=sigma[1,2]
sigma



# Start MEWMA 
lam11=0.75 # parameter of first variable  with shift
lam21=0.75 # parameter of second variable  with shift
cop=mvdc(gumbelCopula(param=theta,dim=2)
         ,margins = c("exp","exp"),
         list(list(1/lam11),list(1/lam21)))


h=6.1425   # ucl of mewma
r=0.02   # smoothing paramerr mewma
ATS=c(0)
for (i in 1:1000)
{
  Z=0
  E=0
  TS=0
   while(E<h)
  {
    X=rMvdc(1,cop)
    Z=r*(X-mu0)+(1-r)*Z
    E=(2-r)/r * Z%*%inv(sigma)%*% t(Z)
    TS=max(X)+TS
   }
  ATS[i]=TS
  print(i)
}
ATS_sim=mean(ATS)
ATS_sim

